<?php

namespace Prk\Woocommerce\Myaccount;

class prk_hooks_account{


    private static $instance = null;

    private function __construct() {
       
        if (is_admin()) return;

        if ( prk_option('myaccount_whishlist_lastviewd') ) {
            add_action('woocommerce_account_dashboard',[$this,'prk_add_view_product_section_user'],3,1);
        }

        if ( prk_option('prk_myaccount_downloads') == 0 || prk_option('prk_myaccount_downloads') == '' ) {
          add_filter( 'woocommerce_account_menu_items', [$this, 'custom_my_account_menu_items'] );
        }

        if ( prk_option('National_code') == '1' ) {
            add_action( 'prk_before_woocommerce_edit_account_form', [$this, 'add_National_code_to_edit_account_form'] );
            add_action( 'woocommerce_save_account_details', [$this, 'my_account_saving_billing_National_code'], 20, 1 );
        }

        if (prk_option('National_code_required') == '1' && prk_option('National_code') == '1' ) {
            add_action( 'woocommerce_save_account_details_errors',[$this, 'billing_National_code_field_validation'], 20, 1 );
        }
        

        add_filter( 'woocommerce_account_menu_items', [$this, 'rename_menu_items' ]);
        add_action( 'prk_before_woocommerce_edit_account_form', [$this, 'add_billing_mobile_phone_to_edit_account_form'],1,1 );
        add_action( 'woocommerce_save_account_details_errors',[$this, 'billing_mobile_phone_field_validation'], 20, 1 );
        add_action( 'woocommerce_save_account_details', [$this, 'my_account_saving_billing_mobile_phone'], 20, 1 );
        add_action( 'template_redirect', [$this, 'prk_redirect_checkout_if_not_logged_in'] );
        add_filter( 'woocommerce_login_redirect', [$this,'prk_redirect_after_login'], 10, 3 );


        if ( prk_option('myaccount_whishlist_sec') ) {
            add_action('woocommerce_account_dashboard',[$this,'prk_add_list_section_user'],2,1);
        }

    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function custom_my_account_menu_items( $items ) {

      unset($items['downloads']);
      return $items;
    }

    public function my_account_saving_billing_National_code( $user_id ) {
        if( isset($_POST['billing_National_code']) && ! empty($_POST['billing_National_code']) )
          update_user_meta( $user_id, 'billing_National_code', sanitize_text_field($_POST['billing_National_code']) );
          update_user_meta( $user_id, 'billing_ncode', sanitize_text_field($_POST['billing_National_code']) );
    }

    public function add_National_code_to_edit_account_form() {
      $user = wp_get_current_user();
      ?>
       <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
          <label for="billing_National_code"><?php _e( 'کد ملی', 'woocommerce' ); ?>
            <?php if (prk_option('opti_checkout_ncode') == 0): ?>
             
            <?php endif; ?>
  
          </label>
          <input type="text" class="woocommerce-Input woocommerce-Input--phone input-text" name="billing_National_code" id="billing_National_code" value="<?php echo esc_attr( $user->billing_National_code ); ?>" autocomplete="billing_ncode" />
      </p>
      <?php
  }



      // Check and validate the mobile phone
    public function billing_National_code_field_validation( $args ){
        if ( isset($_POST['billing_National_code']) && empty($_POST['billing_National_code']) )
       $args->add( 'error', __( 'لطفا کد ملی خود را درست وارد کنید.', 'woocommerce' ),'');
   }
  
    public function rename_menu_items( $items ) {
        $items['customer-logout']    = 'خروج';
        return $items;
    }
    

    // اضافه کردن فیلد شماره تلفن و کد ملی کاربر در صفحه ویرایش حساب کاربری
    public function add_billing_mobile_phone_to_edit_account_form() {
        $user = wp_get_current_user();
        ?>
        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label for="billing_mobile_phone"><?php _e( 'شماره تلفن', 'woocommerce' ); ?>
              <span class="required">*</span>
            </label>
            <input type="text" class="woocommerce-Input woocommerce-Input--phone input-text" name="billing_mobile_phone" id="billing_mobile_phone" value="<?php echo esc_attr( $user->billing_mobile_phone ); ?>" />
        </p>
        <?php
    }

     // Check and validate the mobile phone
    public function billing_mobile_phone_field_validation( $args ){
        if ( isset($_POST['billing_mobile_phone']) && empty($_POST['billing_mobile_phone']) )
            $args->add( 'error', __( 'لطفا شماره تلفن خود را وارد کنید.', 'woocommerce' ),'');
    }

    // Save the mobile phone value to user data
    public function my_account_saving_billing_mobile_phone( $user_id ) {
        if( isset($_POST['billing_mobile_phone']) && ! empty($_POST['billing_mobile_phone']) )
          update_user_meta( $user_id, 'billing_mobile_phone', sanitize_text_field($_POST['billing_mobile_phone']) );
          update_user_meta( $user_id, 'billing_phone', sanitize_text_field($_POST['billing_mobile_phone']) );

    }

    public function prk_redirect_checkout_if_not_logged_in() {
        if ( is_checkout() && ! is_user_logged_in() ) {
            $checkout_url = wc_get_checkout_url(); // ذخیره آدرس صفحه پرداخت
            $login_url = wc_get_page_permalink( 'myaccount' ); // دریافت لینک صفحه ورود
    
            // اضافه کردن پارامتر "redirect_to" به لینک ورود، تا بعد از لاگین کاربر به پرداخت منتقل شود
            $redirect_url = add_query_arg( 'redirect_to', urlencode( $checkout_url ), $login_url );
    
            wp_redirect( $redirect_url );
            exit;
        }
    }
    
    // هدایت به صفحه صحیح بعد از لاگین
    public function prk_redirect_after_login( $redirect_to, $request, $user ) {
        if ( isset( $_GET['redirect_to'] ) && ! empty( $_GET['redirect_to'] ) ) {
            return esc_url( $_GET['redirect_to'] ); // ریدایرکت به صفحه پرداخت
        }
        return $redirect_to; // در غیر این صورت، به مسیر پیش‌فرض برو
    }
    

    public function prk_add_view_product_section_user(){
      ?>
      
      <div class="my-orders-summary profile-section">
      
        <div class="my-orders-summary__header profile-section__header">
      
          <div class="my-orders-summary__title profile-section__title">
            <div>
              <p><?php echo prk_option('myaccount_lastviewd_sec_text');?></p>
            </div>
            <div class="title-border"></div>
          </div>
      
 
      
        </div>
      
        <div class="my-viewed-products__main">
        <?php
    
        $item = '5';
          $settings_slider =  array(
                'loop' => 'false',
                'nav' => 'false',
                'autoplay' => 'false',
                'delay' => 'false',
                'item' => $item,
                'margins' => 5,
            );
          $json_settings = json_encode($settings_slider);
          $viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['woocommerce_recently_viewed'] ) ) : array(); // @codingStandardsIgnoreLine
          $viewed_products = array_reverse( array_filter( array_map( 'absint', $viewed_products ) ) );
          $query_args = array(
           'posts_per_page' => 5,
           'no_found_rows'  => 1,
           'post_status'    => 'publish',
           'post_type'      => 'product',
           'post__in'       => $viewed_products,
           'orderby'        => 'post__in',
          );
      
           $query_args['tax_query'] = array(
             array(
               'taxonomy' => 'product_visibility',
               'field'    => 'name',
               'terms'    => 'outofstock',
               'operator' => 'NOT IN',
             ),
           ); // WPCS: slow query ok.
      
           $loop = new \WP_Query($query_args);
      
          if ( $loop->have_posts() ): ?>
      
           <div class="article-off" settings-slider='<?php echo $json_settings; ?>'>
      
            <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
              <?php
             global $product;
             global $woocommerce;
             $price = get_post_meta( get_the_ID(), '_regular_price', true);
      
             ?>
             <article class="item-pro">
      
                 <a href="<?php the_permalink();?>">
      
      
      
                   <?php echo pr_img(); ?>
      
      
      
                 <div class="index-title-pro">
                    <h2><?php echo wp_trim_words(get_the_title(),12,'...') ;?></h2>
                 </div>
      
                   <!--price-->
                  <div class="index-prices-pro">
      
                    <div class="price_onsale_ar">
      
                         <?php if ($price|| $product->is_type( 'variable' )) {
                           echo $product->get_price_html();
                         }else{
                           echo '<p class="call_pro">', _e('call' , 'parskala'). '</p>';}
                         ?>
      
                    </div>
                  </div>
      
                   </a>
             </article>
      
             <?php endwhile; ?>
             </div>
          <?php wp_reset_postdata(); ?>
           <?php endif;?>
        </div>
      
      
      </div>
      
      <?php
    }

  
        
    public function prk_add_list_section_user(){
        ?>
        
        <div class="my-orders-summary profile-section">
        
          <div class="my-orders-summary__header profile-section__header">
        
            <div class="my-orders-summary__title profile-section__title">
              <div>
                <p><?php echo prk_option('myaccount_whishlist_sec_text');?></p>
              </div>
              <div class="title-border"></div>
            </div>
        
            <!-- <span class="my-orders-summary__more profile-section__more">
              <a class="my-orders-link" href="<?echo get_bloginfo('url');?>/my-account/orders/"><span>مشاهده همه</span>
                <i class="fa fa-chevron-left"></i>
              </a>
            </span> -->
        
          </div>
        
          <div class="my-viewed-products__main">
            <?php
        
            if (theme_style() == 'prk-fashion') {
              $item = '3';
            }else {
              $item = '5';
            }
        
            $settings_slider =  array(
                    'loop' => 'false',
                    'nav' => 'false',
                    'autoplay' => 'false',
                    'delay' => 'false',
                    'item' => $item,
                    'margins' => 5,
                );
        
            $json_settings = json_encode($settings_slider);
            $sit_wishlist_array = sit_get_wishlist_array();
        
            if( !$sit_wishlist_array ){
                $sit_wishlist_array = [];
            }
        
            $sit_loop = new \WP_Query( [
                'post_type' => 'product',
                'posts_per_page' => -1,
                'post__in' => $sit_wishlist_array
            ] );
        
            if($sit_wishlist_array && $sit_loop->have_posts() ): ?>
        
             <div class="article-off" settings-slider='<?php echo $json_settings; ?>'>
        
              <?php while ( $sit_loop->have_posts() ) : $sit_loop->the_post(); ?>
                <?php
               global $product;
               global $woocommerce;
               $price = get_post_meta( get_the_ID(), '_regular_price', true);
        
               ?>
               <article class="item-pro">
        
                   <a href="<?php the_permalink();?>">
        
        
                      <?php echo pr_img(); ?>
        
        
                   <div class="index-title-pro">
                      <h2><?php echo wp_trim_words(get_the_title(),12,'...') ;?></h2>
                   </div>
        
                     <!--price-->
                    <div class="index-prices-pro">
        
                      <div class="price_onsale_ar">
        
                           <?php if ($price|| $product->is_type( 'variable' )) {
                             echo $product->get_price_html();
                           }else{
                             echo '<p class="call_proru">', _e('call' , 'parskala'). '</p>';}
                           ?>
        
                      </div>
                    </div>
        
                     </a>
               </article>
        
               <?php endwhile; ?>
               </div>
            <?php wp_reset_postdata(); ?>
             <?php endif;?>
          </div>
        
        
        </div>
        
        <?php
    }

}