<?php


namespace Prk\Woocommerce\Single\Features;

if (!defined('ABSPATH')) exit; // امنیت

class Product_Return {
    private static $instance;

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('woocommerce_single_product_summary', [$this, 'display_return_info'], 25);
    }

    public function display_return_info() {
        global $post;

        if (!$post || $post->post_type !== 'product') {
            return;
        }

        $return_show = get_post_meta($post->ID, 'product_return_show', true);
        $return_text = $this->get_return_text();

        if ($return_show === 'yes') {
            echo '<div class="product_return">';
            echo '<i class="ri-error-warning-line"></i>';
            echo '<span>' . esc_html($return_text) . '</span>';
            echo '</div>';
        }
    }

    private function get_return_text() {
        return get_post_meta(get_the_ID(), 'product_return_text', true) ?: 'این محصول امکان بازگشت دارد!';
    }
}