<?php

/**
 *  📌 PRK Single Product Hooks & Components
 *  ----------------------------------------
 *  این کلاس جهت مدیریت هوک‌های صفحه محصول و کامپوننت‌های مرتبط توسعه داده شده است.
 *  
 *  🛠 توسعه‌دهنده: حسین اسماعیلیان
 *  تاریخ ایجاد: ۱۴۰۳/۱۲/۱۰
 *  توضیحات: این ساختار با استفاده از شی‌گرایی طراحی شده تا فقط در صورت نیاز، کامپوننت‌های صفحه محصول بارگذاری شوند.
 *  بهینه‌سازی: جلوگیری از بارگذاری غیرضروری فایل‌ها و کاهش فشار روی سرور.
 *  
 *  @author Hossein Esmaeilian
 *  
 */

namespace Prk\Woocommerce\Single;

use Prk\Woocommerce\Single\components;

class prk_Single_Product_hooks {
    
    private static $instance = null; 
    private $component;


    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self(); 
        }
        return self::$instance;
    }

    private function __construct() {
       
        if (is_admin()) return;
        $this->component = Components::get_instance(); // مقداردهی کامپوننت‌ها
        require_once get_theme_file_path('app/Woocommerce/Single/advanced_review.php');
        add_action('init', [$this,'display_related_filter_set']);
        add_action( 'comment_post', [$this, 'add_postmeta_recommended'], 99, 2);
        add_filter( 'woocommerce_product_reviews_tab_title', [$this, 'bbloomer_rename_reviews_product_tab_label'] );
        add_filter( 'woocommerce_product_additional_information_tab_title', [$this, 'bbloomer_rename_additional_information_product_tab_label'] );
        add_action('woocommerce_product_additional_information',[$this, 'add_costom_element_informationproduct_tab'],1);
    }


        /**
     * لود کردن استایل و اسکریپت‌های مورد نیاز
     */
    public function enqueue_scripts() {
  
        wp_enqueue_style(
          'highcharts-js',
          get_template_directory_uri() . '/app/Woocommerce/Single/Features/assets/js/highcharts.js'
        );
        

    }

    // جابجایی سکشن محصولات مربتط در دموهای قالب
    public function display_related_filter_set(){
        if  ( prk_option('show_related') == '9' ){
            remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
            add_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 9);
        }
    }


    //add postmeta recommended    
    public function add_postmeta_recommended($comment_id, $comment_object){
        $comment = get_comment( $comment_id );
        $comment_post_id = $comment->comment_post_ID ;
        $recommend = get_comment_meta( $comment_id, 'recommend', true );
        if($recommend == 'recommended'){
            $count = get_post_meta($comment_post_id , 'count_recommended', true);
            if(empty($count)){
            update_post_meta($comment_post_id, 'count_recommended', 1);
            }else{
            $count++;
            update_post_meta($comment_post_id, 'count_recommended', $count);
            }
        }
    }

    // اضافه کردن تعداد دیدگاه محصول در تب محصول
    public function bbloomer_rename_reviews_product_tab_label() {
        $des_title = '';
        global $product;
        $count = $product->get_review_count();
        $des_title = esc_html_e('Comments','parskala').'<i>'. $count .'</i>';
        if ( mobile_cheker() || tablet_cheker() ) {
            $des_title = '<span class="cooment_mobile_title">مفید ترین نظرات</span><a class="insert_comment_mobile" href="'.add_query_arg( 'insert-comment', '', get_the_permalink() ).'">افزودن نظر جدید +</a>';
        }

        return $des_title;
    }
    // تغییر عنوان مشخصات تب محصول
    public function bbloomer_rename_additional_information_product_tab_label(){
        return prk_option('information_product_title') ? prk_option('information_product_title') : __('info','parskala');
    }
    // اضافه کردن عنوان محصول در خود تب محصول
    public function add_costom_element_informationproduct_tab(){
        if (prk_option('sub_title_show_product') == '1' ) {
            echo '<span class="title-desctop">'.get_the_title().'</span>';
        }
    }




}

