<?php


function check_dokan_plugin_state() {
  if (is_plugin_active('dokan-lite/dokan.php')) {
    return true;
  }
  else {
    return false;
  }
}
add_action('admin_init', 'check_dokan_plugin_state');


if ( prk_option('header_minicart_type') == 'dropdown' ){

  include(parskala_TEMPLATEPATH.'/app/Woocommerce/Globals/class_mini_cart.php');

}


if (  prk_option('prk_gattributes_enable') == 1 || prk_option('prk_gattributes_enable') == NULL  ) {
  add_action('after_setup_theme', function() {
      include(parskala_TEMPLATEPATH.'/app/Modules/gattributes/gattributes.php');
  });
}


// سیستم ویرایشگر فرم صفحه پرداخت
if (prk_option('checkout_manager_form') == '1'){
  include(parskala_TEMPLATEPATH.'/app/Modules/Checkout/checkout_customizer.php');
}

/*
   ================================
        Woocommerce Support
   ================================
*/

add_action( 'after_setup_theme', 'prk_woocommerce_support' );
function prk_woocommerce_support() {
  add_theme_support( 'woocommerce' );

}

add_action( 'after_setup_theme', 'remove_image_zoom_support', 100 );
function remove_image_zoom_support() {
    remove_theme_support( 'wc-product-gallery-zoom' );
}

// اضافه کردن اکشن سفارشی برای جلوگیری از خطای تکسونومی برندهای ووکامرس
add_action('init', function () {
  remove_action('woocommerce_structured_data_product', [ 'WC_Brands', 'add_structured_data' ], 10);
  add_action('woocommerce_structured_data_product', function ($data, $product) {
      if (!is_array($data)) {
          $data = [];
      }
      return $data;
  }, 10, 2);
});

//prk Get base shop page link
if ( ! function_exists( 'prk_shop_page_link' ) ) {
  function prk_shop_page_link( $keep_query = false, $taxonomy = '' ) {
    // Base Link decided by current page
    $link = '';
    if ( class_exists( 'Automattic\Jetpack\Constants' ) && Automattic\Jetpack\Constants::is_defined( 'SHOP_IS_ON_FRONT' ) ) {
      $link = home_url();
    } elseif ( is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) || is_shop() ) {
      $link = get_permalink( wc_get_page_id( 'shop' ) );
    } elseif ( is_product_category() ) {
      $link = get_term_link( get_query_var( 'product_cat' ), 'product_cat' );
    } elseif ( is_product_tag() ) {
      $link = get_term_link( get_query_var( 'product_tag' ), 'product_tag' );
    } elseif ( get_queried_object() ) {
      $queried_object = get_queried_object();

      if ( property_exists( $queried_object, 'taxonomy' ) ) {
        $link = get_term_link( $queried_object->slug, $queried_object->taxonomy );
      }
    }

    if ( $keep_query ) {

      // Min/Max
      if ( isset( $_GET['min_price'] ) ) {
        $link = add_query_arg( 'min_price', wc_clean( $_GET['min_price'] ), $link );
      }

      if ( isset( $_GET['max_price'] ) ) {
        $link = add_query_arg( 'max_price', wc_clean( $_GET['max_price'] ), $link );
      }

      // Orderby
      if ( isset( $_GET['orderby'] ) ) {
        $link = add_query_arg( 'orderby', wc_clean( $_GET['orderby'] ), $link );
      }

      if ( isset( $_GET['stock_status'] ) ) {
        $link = add_query_arg( 'stock_status', wc_clean( $_GET['stock_status'] ), $link );
      }

            if ( isset( $_GET['filter_brand'] ) ) {
        $link = add_query_arg( 'filter_brand', wc_clean( $_GET['filter_brand'] ), $link );
      }

            if ( isset( $_GET['filter_cat'] ) ) {
        $link = add_query_arg( 'filter_cat', wc_clean( $_GET['filter_cat'] ), $link );
      }

      if ( isset( $_GET['per_row'] ) ) {
        $link = add_query_arg( 'per_row', wc_clean( $_GET['per_row'] ), $link );
      }

      if ( isset( $_GET['per_page'] ) ) {
        $link = add_query_arg( 'per_page', wc_clean( $_GET['per_page'] ), $link );
      }

      if ( isset( $_GET['shop_view'] ) ) {
        $link = add_query_arg( 'shop_view', wc_clean( $_GET['shop_view'] ), $link );
      }

      if ( isset( $_GET['shortcode'] ) ) {
        $link = add_query_arg( 'shortcode', wc_clean( $_GET['shortcode'] ), $link );
      }

      /**
       * Search Arg.
       * To support quote characters, first they are decoded from &quot; entities, then URL encoded.
       */
      if ( get_search_query() ) {
        $link = add_query_arg( 's', rawurlencode( wp_specialchars_decode( get_search_query() ) ), $link );
      }

      // Post Type Arg
      if ( isset( $_GET['post_type'] ) ) {
        $link = add_query_arg( 'post_type', wc_clean( wp_unslash( $_GET['post_type'] ) ), $link );

        // Prevent post type and page id when pretty permalinks are disabled.
        if ( is_shop() ) {
          $link = remove_query_arg( 'page_id', $link );
        }
      }

      // Min Rating Arg
      if ( isset( $_GET['min_rating'] ) ) {
        $link = add_query_arg( 'min_rating', wc_clean( $_GET['min_rating'] ), $link );
      }

      // All current filters
      if ( $_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes() ) {
        foreach ( $_chosen_attributes as $name => $data ) {
          if ( $name === $taxonomy ) {
            continue;
          }
          $filter_name = sanitize_title( str_replace( 'pa_', '', $name ) );
          if ( ! empty( $data['terms'] ) ) {
            $link = add_query_arg( 'filter_' . $filter_name, implode( ',', $data['terms'] ), $link );
          }
          if ( 'or' == $data['query_type'] ) {
            $link = add_query_arg( 'query_type_' . $filter_name, 'or', $link );
          }
        }
      }
    }

    $link = apply_filters( 'prk_shop_page_link', $link, $keep_query, $taxonomy );

    if ( is_string( $link ) ) {
      return $link;
    } else {
      return '';
    }
  }
}

//prk shop filter query
add_action( 'woocommerce_product_query', 'prk_shop_filter_query' );
if ( ! function_exists( 'prk_shop_filter_query' ) ) {
    function prk_shop_filter_query( $q ){
    if ( ( ( is_woocommerce() && is_archive() ) || is_shop() ) ) {

        $current_stock_status = isset( $_GET['stock_status'] ) ? explode( ',', $_GET['stock_status'] ) : array();
        $filter_brand = isset( $_GET['filter_brand'] ) ? explode( ',', $_GET['filter_brand'] ) : array();
        $product_cat = isset( $_GET['filter_cat'] ) ? explode( ',', $_GET['filter_cat'] ) : array();

            if( in_array( 'onsale', $current_stock_status ) ) {
                $product_ids_on_sale = wc_get_product_ids_on_sale();
                $q->set( 'post__in', $product_ids_on_sale );
            }

            if( in_array( 'instock', $current_stock_status ) ) {
                $query_array = array(
                    'relation' => 'AND',
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock',
                        'compare' => '=',
                    )
                );
                $q->set( 'meta_query', $query_array );
            }

            if( !empty( $filter_brand ) ) {
                $tax_query = array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' =>  'brand',
                        'field' => 'term_id',
                        'terms' => $filter_brand,
                    )
                );
                $q->set( 'tax_query', $tax_query );
            }

            if( !empty( $product_cat ) ) {
                $tax_query = array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $product_cat,
                    )
                );
                $q->set( 'tax_query', $tax_query );
            }

			if(isset($_COOKIE['prskalaSearchCity']) && !empty(($_COOKIE['prskalaSearchCity']))){
				$city_categories=explode(',', $_COOKIE['prskalaSearchCity']);
				if (!empty($city_categories) && $city_categories !== 0) {
          if (isset($tax_query["tax_query"]) && is_array($tax_query["tax_query"])) {
						$tax_query ["tax_query"][] = ["taxonomy" => "city_categories", "field" => "id", "terms" => $city_categories];
					} else {
						$tax_query ["tax_query"] = ["relation" => "AND", ["taxonomy" => "city_categories", "field" => "id", "terms" => $city_categories]];
					}
			   }
			   $q->set( 'tax_query', $tax_query );
			}




        }
    }
}



/*
   ================================
        Woocommerce Single Product
   ================================
*/

// متن پیشفرض محصول غیر اصل
function product_facke_value() {

  $def_date = '';
  if (empty(get_post_meta(get_the_ID(), 'product_facke_brand_text', true ))) {
     $def_date = 'این محصول به وسیله تولید کننده اصلی(برند) تولید نشده است.';
  }else {
     $def_date = get_post_meta(get_the_ID(), 'product_facke_brand_text', true );
  }
  return $def_date;

}

// متن پیشفرض امکان بازگشت
function product_return_value() {

  $def_date = '';
  if (empty(get_post_meta(get_the_ID(), 'product_return_text', true ))) {
     $def_date = 'امکان برگشت کالا با دلیل "انصراف از خرید" تنها در صورتی مورد قبول است که پلمب کالا باز نشده باشد.';
  }else {
     $def_date = get_post_meta(get_the_ID(), 'product_return_text', true );
  }
  return $def_date;

}

// متن پیشفرض گارانتی محصول
function general_granty_value() {

  $granty_value = '';
  $general_granty = prk_option('single_texts_Warrantyss');
  if ( empty( get_post_meta(get_the_ID(), 'product_granti_text', true) ) ) {
     $granty_value = $general_granty;
  }elseif( !empty( get_post_meta(get_the_ID(), 'product_granti_text', true) ) ){
     $granty_value = get_post_meta(get_the_ID(), 'product_granti_text', true );
  }else {
    $granty_value = '';
  }
  return $granty_value;

}

// متن پیشفرض ضمانت محصول
function general_orginal_value() {

  $orginal_value = '';
  $general_orginal = prk_option('single_product_bail_text');
  if (empty(get_post_meta(get_the_ID(), 'product_Original_text', true ))) {
     $orginal_value = $general_orginal;
  }else{
     $orginal_value = get_post_meta(get_the_ID(), 'product_Original_text', true );
  }
  return $orginal_value;

}

// متن پیشفرض هشدار سامانه همتا
function general_hamta_value() {

  $hamta_value = '';
  $general_hamta = prk_option('single_hamta_text');
  if (empty(get_post_meta(get_the_ID(), 'product_hamta_text', true ))) {
     $hamta_value = $general_hamta;
  }else{
     $hamta_value = get_post_meta(get_the_ID(), 'product_hamta_text', true );
  }
  return $hamta_value;

}

// add author and add to card loop
function prk_author_loop_product(){
    pr_author();
}

function pr_star(){
    $ratings_nummbercomment = '';
    global $product;
    global $post;
    if ($product->get_rating_count() > 0){
    ?>
    <div class="rating_and_nummbercomment">
        <div class="rating_product">
        <span class="average_rating"><?php echo $product->get_average_rating(); ?></span>
        <i class="ri-star-fill star"></i>
        <!-- <span class="rating_count">از <?php echo $product->get_rating_count(); ?> رای </span> -->
        </div>

    </div>
    <?php
    }
}

function prod_defualt_thumb() {
    $defualt_thumb = prk_option('prk_defualt_thumb_pr');
    echo '<img src="'. $defualt_thumb['url'] .'" width="150" height="150" alt="'.the_title_attribute('echo=0').'" class="post-thumb">';
}

function pr_img() {
    global $product;
    $classes = '';
    if( prk_option( 'show_sec_img' ) ) {
        $attachment_ids = $product->get_gallery_image_ids();
        if ( is_array( $attachment_ids ) && !empty( $attachment_ids ) ) {
            $classes = 'hover-image';
        }
    }
    echo '<div class="thumb-pro '.$classes.'  duration-500  group-hover:-mt-[22px] group-hover:-rotate-1">';

    do_action( 'prk_before_shop_loop_item_img' );

    if ( has_post_thumbnail() ) {
        the_post_thumbnail('woocommerce_thumbnail');
    } else {
        prod_defualt_thumb();
    }
    if( prk_option( 'show_sec_img' ) ) {
        $first_image_url = '';
        $attachment_ids = $product->get_gallery_image_ids();
        if ( is_array( $attachment_ids ) && !empty($attachment_ids) && isset($attachment_ids[0])) {
            $first_image_url = wp_get_attachment_image_src($attachment_ids[0], 'woocommerce_thumbnail');
            if ($first_image_url ) {
            echo '<img width="'.$first_image_url[1].'" height="'.$first_image_url[2].'" src="'.$first_image_url[0].'" alt="'.get_the_title().'" class=" second-img wp-post-image">';

            }
        }
    }
    do_action( 'prk_after_shop_loop_item_img' );

    echo '</div>';
}

function pr_stock(){

    $product_stock = prk_option('archive_product_stock');
    global $product;
    if ($product_stock){
  
      echo '<span class="stock-archive">';
  
     if($product->is_type( 'variable' )){
        $variation_ids = $product->get_children();
        $product_is_instock = false;
      foreach($variation_ids as $variation_id){
        $variation = wc_get_product($variation_id);
        if( $variation->is_in_stock()){
          $product_is_instock = true;
          break;
        }
   
      }
  
      if($product_is_instock){
        
        echo '<span class="in-stock">
  
        '.__('in stock' , 'parskala').'
  
      </span>';
        
      }else{
        echo '<i class="share-square"></i>';
  
        echo '<span class="in-stock">
  
        '.__('Not available in stock' , 'parskala').'
  
       </span>';
  
      }
  
      }else{
  
  
        if ($product->is_in_stock()){
  
          echo '<i class="share-square"></i>';
  
           if (wc_get_stock_html( $product )){
            echo '<span class="stockon">' .wc_get_stock_html($product). '</span>';
          }
          else{
            echo '<span class="in-stock">
  
              '.__('in stock' , 'parskala').'
  
            </span>';
          }
  
        }
        else{
  
          echo '<i class="share-square"></i>';
          echo '<span class="in-stock">
  
           '.__('Not available in stock' , 'parskala').'
  
          </span>';
  
        }
  
      
      }
  
      echo '</span>';
  
    }
  
}


function prk_price_loop_product(){

    global $post, $product;
    global $woocommerce;
    $price = get_post_meta( get_the_ID(), '_regular_price', true);

    //price
    echo '<div class="index-prices-pro">';
    echo '<div class="price_onsale_ar">';

    if ( $product->is_in_stock() && $price|| $product->is_type( 'variable' )) {

        echo $product->get_price_html();

        }elseif($product->is_in_stock()){

            echo '<p class="call_pro">'.prk_option('single_product_text_price').'</p>';
        }

        echo '</div>';

        echo '</div>';
        
}

function pr_author(){

    global $post, $product;
    global $woocommerce;
    $seller_name = prk_option('archive_product_seller_name');
    $product_orginal = prk_option('archive_product_orginal');
    $Original_pro = get_post_meta(get_the_ID(),'product_facke_brand_show',true);
    $product_stock = prk_option('archive_product_stock');
    $product_thumbnail_2 = prk_option('archive_product_thumbnail_2');
    $vendor_id = get_post_field( 'post_author', get_the_id() );
  
    include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
    $active_dokan = is_plugin_active( 'dokan-lite/dokan.php' );
    if($active_dokan){
    $vendor = new WP_User($vendor_id);
      $store_info  = dokan_get_store_info( $vendor_id );
      $store_name  = $store_info['store_name'];
      $store_url   = dokan_get_store_url( $vendor_id );
    }
  
  // author
  ?>
  <div class="author-Original">
  
    <?php if ($product_orginal):?>
  
      <?php if($Original_pro=="yes"):?> 
  
      <span class="no-Original"><?php _e('غیر اصل' , 'parskala');?></span>
  
      <?php endif;?>
  
    <?php endif;?>
  
    <?php if ($seller_name):?>
  
      <span class="author-ar"><i class="seller-store"></i> <?php _e(' فروشنده: ' , 'parskala');?>
  
        <?php if($active_dokan):?>
  
          <span class="authours-ar"><?php echo $store_name;?></span>
  
        <?php else:?>
  
          <?php echo get_the_author_meta( 'display_name');?>
  
        <?php endif;?>
  
      </span>
  
    <?php endif;?>
  
  </div>
  
  <?php
}
function pr_quantity(){
    global $post, $product;
    global $woocommerce;
    ?>
  
    <div class="prk_cart">
      <?php echo woocommerce_quantity_input(['min_value' => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product), 'max_value' => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),], $product, false); ?>
      <div class="lists_add_to_cart">
        <?php echo do_shortcode("[ajax_cart_item]");?>
      </div>
    </div>
    <?php
}



function prk_swatches_archive_attr() {
  return prk_option( 'swatches_archive_attr' );
}


//Get terms link
function prk_get_term_links( $term_tax, $term_ids ) {

    if ( is_array( $term_ids ) )
    {
        $term_tax_link = ( $term_tax == 'category' ? 'cat' : $term_tax );
        $term_tax_link = ( $term_tax == 'post_tag' ? 'tag' : $term_tax );
        if( count( $term_ids ) == 1 ) {
            $term_link = get_term_link( (int)$term_ids[0], $term_tax );
        } else {
            $term_link = get_home_url() . '/?' .$term_tax_link.'=';
            foreach( $term_ids as $id ) {
                $term = get_term( $id, $term_tax );
                $slug = $term->slug;
                $term_link .= $slug . ',';
            }
        }
    } else {
    $term_link = get_term_link( (int)$term_ids, $term_tax );
    }
    return $term_link;
}

function prk_swatches_list( $attribute_name = false ) {
  global $product;

  $id = $product->get_id();

  if ( empty( $id ) || ! $product->is_type( 'variable' ) ) {
    return false;
  }

  if ( ! $attribute_name ) {
    $attribute_name = prk_swatches_archive_attr();
  }

  if ( empty( $attribute_name ) ) {
    return false;
  }

  $available_variations = array();

  if ( ! $available_variations ) {
    $available_variations = $product->get_available_variations();
  }

  if ( empty( $available_variations ) ) {
    return false;
  }

  $swatches_to_show = prk_get_option_variations( $attribute_name, $available_variations, false, $id );

  if ( empty( $swatches_to_show ) ) {
    return false;
  }

  $out = '';

  $out .= '<div class="prk-archive-swatches">';

  $index = 0;

  foreach ( $swatches_to_show as $key => $swatch ) {
    $style = $class = '';

    $swatch_limit = prk_option( 'swatches_archive_count' );
    if ( prk_option( 'enable_swatches_archive_count' ) && count( $swatches_to_show ) > (int) $swatch_limit ) {
      if ( $index >= $swatch_limit ) {
        $class .= ' prk-hidden';
      }
      if ( $index === (int) $swatch_limit ) {
        $out .= '<div class="prk_swatches-divider">+' . ( count( $swatches_to_show ) - (int) $swatch_limit ) . '</div>';
      }
    }

    $index++;

    if ( $swatch['color'] ) {
      $style = 'style="background-color:' . $swatch['color'] . '"';
      $class .= ' prk-swatch-with-bg';
      $class .= prk_option( 'swatches_circle_style' ) ? ' prk-swatche-circle' : '';
      $text_swatches = '';
    } elseif ( $swatch['text'] ) {
              $style = '';
      $class .= ' prk-swatch-text';
      $text_swatches = $term->name;
    }

    $term = get_term_by( 'slug', $key, $attribute_name );

    $title = prk_option('show_swatches_archive_title') ? ' <span class="tooltiptext">' .$term->name. '</span> ' : '';
    $out .= '<div class="prk-archive-swatch' . esc_attr( $class ) . '" ' . $style. '>' . $text_swatches . $title . '</div>';
  }

  $out .= '</div>';

  echo $out;

}


if ( prk_option( 'show_swatches_archive', '1') == '1') {
  add_action ( 'woocommerce_before_shop_loop_item_title', 'prk_swatches_list' );
  add_shortcode('prk_swatches_list', 'prk_swatches_list' );
}


if ( ! function_exists( 'prk_get_option_variations' ) ) {
  function prk_get_option_variations( $attribute_name, $available_variations, $option = false, $product_id = false ) {
    $swatches_to_show = array();

    //$product_image_id = get_post_thumbnail_id( $product_id );

    foreach ( $available_variations as $key => $variation ) {
      $option_variation = array();
      $attr_key         = 'attribute_' . $attribute_name;
      if ( ! isset( $variation['attributes'][ $attr_key ] ) ) {
        return;
      }

      $val = $variation['attributes'][ $attr_key ];

      // Get all variations with swatches to show by attribute name
            $swatch                   = prk_has_swatch( $product_id, $attribute_name, $val );
            $swatches_to_show[ $val ] = $swatch;
    }

    return $swatches_to_show;

  }
}

if ( ! function_exists( 'prk_has_swatch' ) ) {
  function prk_has_swatch( $id, $attr_name, $value ) {
    $swatches = array();

    $color = $image = $not_dropdown = '';

    $term = get_term_by( 'slug', $value, $attr_name );
    if ( is_object( $term ) ) {
        $color     =  get_term_meta( $term->term_id,'product_'.$attr_name, true);
    }

    if ( $color != '' ) {
      $swatches['color'] = $color;
    } else {
            $swatches['text'] = true;
        }

    return $swatches;
  }
}



// add_filter( 'jetpack_images_get_images', 'jeherve_custom_image', 10, 3 );
function jeherve_custom_image( $media, $post_id, $args ) {
  if ( $media ) {
      return $media;
  } else {
      $permalink = get_permalink( $post_id );
      $url = apply_filters( 'jetpack_photon_url', 'YOUR_LOGO_IMG_URL' );

      return array( array(
          'type'  => 'image',
          'from'  => 'custom_fallback',
          'src'   => esc_url( $url ),
          'href'  => $permalink,
      ) );
  }
}



add_filter( 'loop_shop_per_page', 'prk_bbloomer_redefine_products_per_page', 9999 );
function prk_bbloomer_redefine_products_per_page( $per_page ) {
   $per_page = prk_option('prk_products_per_page_loop') ? prk_option('prk_products_per_page_loop') : '20';
   return $per_page;
}





// اضافه کردن کلاس سفارشی به تابع نمایش قیمت در ووکامرس
add_filter( 'woocommerce_get_price_html', 'wpa83367_price_html', 100, 2 );
function wpa83367_price_html( $price ){

  $cstom_calss_aria  =  '<del aria-hidden="true"><span class="woocommerce-Price-amount amount sale_price"><bdi>';

  $before_calss_aria =  '<del aria-hidden="true"><span class="woocommerce-Price-amount amount"> <bdi>' ;

  return str_replace( $before_calss_aria, $cstom_calss_aria , $price );

}

add_filter( 'woocommerce_get_price_html', 'wpa8w3367_price_html', 100, 2 );
function wpa8w3367_price_html( $price ){

  $cstom_calss = '<del><span class="woocommerce-Price-amount amount sale_price"><bdi>';

  return str_replace( '<del><span class="woocommerce-Price-amount amount"><bdi>',$cstom_calss , $price );


}

// add_filter( 'woocommerce_get_price_html', 'wpa8w33f67_price_html', 100, 2 );
function wpa8w33f67_price_html( $price ){

  $cstom_calss = '<ins><span class="woocommerce-Price-amount amount price_sale"><bdi>';

  return str_replace( '<ins><span class="woocommerce-Price-amount amount"><bdi>',$cstom_calss , $price );


}

// add_filter( 'woocommerce_get_price_html', 'wpa8w33df67_price_html', 100, 2 );
function wpa8w33df67_price_html( $price ){

  $sale = get_post_meta( get_the_ID(), '_sale_price', true);
  $cstom_calss = '<span class="woocommerce-Price-amount amount price_sale"><bdi>';

  return str_replace( '<span class="woocommerce-Price-amount amount">',$cstom_calss , $price );

}



function prk_grid_loop_columns_product(){
	$columns_product = '';
	if ( !empty(prk_option('prk_loop_columns_product')) ){
		$columns_product = 'style="grid-template-columns: repeat('.prk_option('prk_loop_columns_product').',1fr)"';
	}
	return $columns_product;
 }


 
# random id
function generateRandomString($length = 5) {
  $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
  $charactersLength = strlen($characters);
  $randomString = '';
  for ($i = 0; $i < $length; $i++) {
      $randomString .= $characters[rand(0, $charactersLength - 1)];
  }
  return $randomString;
}

function slider_RandomString($length = 10) {
  $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
  $charactersLength = strlen($characters);
  $randomString = '';
  for ($i = 0; $i < $length; $i++) {
      $randomString .= $characters[rand(0, $charactersLength - 1)];
  }
  return $randomString;
}


if (!function_exists('PRK_cart_count')) {
  function PRK_cart_count(){
  $count = WC()->cart->cart_contents_count;
   echo esc_html($count);
  }
}