<?php
namespace Prk;

use Prk\traits\Singleton;

class prk_assets{

    use Singleton;

    public function __construct(){

       add_action('admin_enqueue_scripts', [$this, 'load_admin_assets']);

    }

    public static function get_localize_data(){
        $data = [
            'au' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ahura_nonce'),
            'merlin_nonce' => wp_create_nonce('merlin_nonce'),
            'translate' => array(
                'weight'=> __('Weight', 'ahura'),
                'normal'=> __('Normal', 'ahura'),
                'bold'=> __('Bold', 'ahura'),
                'select_font'=> __('Select an Font', 'ahura'),
                'select_file'=> __('Select an File', 'ahura'),
                'select'=> __('Select', 'ahura'),
                'are_you_sure'=> __('Are you sure?', 'ahura'),
                'edit'=> __('Edit', 'ahura'),
                'delete'=> __('Delete', 'ahura'),
                'cancel'=> __('Cancel', 'ahura'),
                'select_woff_file'=> __('Select WOFF File', 'ahura'),
                'select_woff2_file'=> __('Select WOFF2 File', 'ahura'),
                'select_ttf_file'=> __('Select TTF File', 'ahura'),
                'select_svg_file'=> __('Select SVG File', 'ahura'),
                'select_eot_file'=> __('Select EOT File', 'ahura'),
                'studio_import_title'=> __('Import Demo Data', 'ahura'),
                'studio_import_placeholder'=> __('Enable this option to install faster and avoid consuming hosting resources.', 'ahura'),
                'studio_import_progress'=> __('Importing demo is in progress.', 'ahura'),
                'studio_import'=> __('Import', 'ahura'),
                'studio_import_done'=> __('Demo Imported!', 'ahura'),
                'studio_import_error'=> __('Failed Demo Import!', 'ahura'),
                'studio_server_error'=> __('A server side error occurred.', 'ahura'),
                'unknown_error'=> __('An error occurred, please try again.', 'ahura'),
                'studio_sideload_tooltip' => __( 'If you are importing on localhost or if you encounter any problem in importing the demo, if you are using vpn, please turn it off and import again.', 'ahura' ),
                'plz_wait' => __( 'Please Wait...', 'ahura' ),
                'request_is_progress' => __( 'The request is in progress...', 'ahura' ),
                // 'doing' => __( 'Doing...', 'ahura' ),
            ),
        ];

        return $data;
    }

    public function load_admin_assets()
    {
        $version = \Prk\Theme_Setup::get_theme_version();
        $localize_data = self::get_localize_data();

        wp_enqueue_script('prk_studio_script', get_template_directory_uri() .'/app/Admin/assets/js/studio.js', [], false, true);
        wp_enqueue_style('prk_studio_Hob', get_template_directory_uri() .'/app/Admin/assets/css/custom.css');
        wp_localize_script('prk_studio_script', 'ahura_data', $localize_data);

        if(\Prk\Admin\Studio::is_studio()){
            wp_enqueue_style('prk_studio_style', get_template_directory_uri() .'/app/Admin/assets/css/studio.css');
           

    
                
            wp_enqueue_script('merlin', get_template_directory_uri() .'/inc/wizard/merlin/assets/js/merlin.js', null, $version, true);
            wp_localize_script(
                'merlin', 'merlin_params', array(
                    'ajaxurl' => admin_url( 'admin-ajax.php' ),
                    'wpnonce' => wp_create_nonce( 'merlin_nonce' ),
                    'texts'   => array(
                        'something_went_wrong' => esc_html__( 'Something went wrong. Please refresh the page and try again!', 'ahura' ),
                    ),
                )
            );

            wp_enqueue_script('prk_sweetalert_js', get_template_directory_uri() .'/assets/js/sweetalert2.min.js', null, $version, true);

        }
        wp_enqueue_script('prk_custom_js', get_template_directory_uri() .'/app/Admin/assets/js/custom.js', [], false, true);
        wp_localize_script('prk_custom_js', 'assets_data', $localize_data);
    }

}
