document.addEventListener('DOMContentLoaded', function () {
    const input = document.getElementById('ag-themer-input');
    const titleBox = document.getElementById('ag-themer-title');

    if (input && titleBox) {
        input.addEventListener('input', function () {
        const value = input.value.trim();
        titleBox.textContent = value ? `ویرایش «${value}»` : 'طرح جدید!';
        });
    }
});

jQuery(document).ready(function($) {

    const $templateTypeSelect = $('[name="ag_theme_builder_template_type"]');

    $templateTypeSelect.on('change', function () {
        const value = $(this).val();
        
        if (value) {
        $('.ag-theme-builder-target-rules-row').removeClass('hidden');
        } else {
        $('.ag-theme-builder-target-rules-row').addClass('hidden');
        }
    });

    const $form = $("#post");
    const $saveBtn = $(".ag-ui-save-btn");

    jQuery(".ag-target-rule-selector-wrapper").on("click", ".target_rule-condition-delete,.target_rule-add-rule-wrap a", function (e) {
    e.preventDefault();
    $saveBtn.removeClass("disabled").addClass("enabled");
    });

    jQuery(".ag-user-role-selector-wrapper").on("click", ".user_role-add-rule-wrap a,.user_role-condition-delete ", function (r) {
    r.preventDefault();
        $saveBtn.removeClass("disabled").addClass("enabled");
    });

    $form.on("input change", ":input", function () {
        $saveBtn.removeClass("disabled").addClass("enabled");
    });

    $(".ag-ui-submit-btn").on("click", function () {
        const $submit_btn = $(this);
        $submit_btn.addClass("is-loading").text("در حال ذخیره ...");

    });

  $(".ag-ui-save-btn").on("click", function (e) {
    e.preventDefault();

    const $btn = $(this);
    const postId = $btn.data("post-id");

    if (!postId || !window.ajax_nonces?.save_ag_themer) return;

    const $form = $("#post");
    const formData = new FormData($form[0]);

    // 📦 فشرده‌سازی فیلدهای تکرارشونده Location
    const extractRules = (prefix) => {
      const rule = [];
      const specific = [];

      $(`[name^="${prefix}[rule]"]`).each(function () {
        const val = $(this).val();
        if (val) rule.push(val);
      });

      $(`[name^="${prefix}[specific]"]`).each(function () {
        const $select = $(this);
        const selected = $select.val(); // چون Select2 هست val خودش آرایه است
        if (Array.isArray(selected)) {
          specific.push(...selected);
        }
      });

      return { rule, specific };
    };

    const includeRules = extractRules('ag-theme-builder-target-rules-location');
    const excludeRules = extractRules('ag-theme-builder-target-rules-exclusion');

    formData.append("ag_theme_builder_target_include_locations_json", JSON.stringify(includeRules));
    formData.append("ag_theme_builder_target_exclude_locations_json", JSON.stringify(excludeRules));

    // 📨 ادامه فرم
    formData.append("action", "save_ag_themer_post");
    formData.append("nonce", ajax_nonces.save_ag_themer);
    formData.append("post_id", postId);

    $btn.prop("disabled", true).addClass("is-loading").text("در حال ذخیره ...");

    fetch(ajax_nonces.ajaxurl, {
      method: "POST",
      body: formData,
    })
    .then((res) => res.json())
    .then((response) => {
      console.log("RESPONSE:", response);
      if (response.success) {
        queue_alert(response.data.message || "با موفقیت ذخیره شد", 'success', 2000);
      } else {
        queue_alert(response.data.message || "خطا در ذخیره‌سازی", 'error', 3000);
      }
    })
    .catch(() => {
      queue_alert("ارتباط برقرار نشد", 'error', 3000);
    })
    .finally(() => {
      $btn.prop("disabled", false).removeClass("is-loading").text("ذخیره کردن");
      $saveBtn.removeClass("enabled").addClass("disabled");
    });
  });
});

